<?php
/*--------------------------------------------------------------
   Version.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects;

use Webmozart\Assert\Assert;

class Version
{
    private const REGEX = '/^([0-9]+)\.([0-9]+)\.([0-9]+)(?:-([0-9A-Za-z-]+(?:\.[0-9A-Za-z-]+)*))?(?:\+[0-9A-Za-z-]+)?$/';
    
    /**
     * @var string
     */
    private $value;
    
    
    /**
     * Constructor.
     */
    private function __construct(string $value)
    {
        Assert::stringNotEmpty($value);
        Assert::regex($value, self::REGEX);
        
        $this->value = $value;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(string $version): self
    {
        return new self($version);
    }
    
    
    /**
     * Return value.
     */
    public function value(): string
    {
        return $this->value;
    }
}